<?php
/**
 * Test Data Generator for HR Management Dashboard
 * 
 * Instructions:
 * 1. Copy this file to your WordPress root directory
 * 2. Access it via browser: http://localhost/wordpress/test-data-generator.php
 * 3. This will create sample employees, attendance, leave requests, and payroll
 */

// Load WordPress
require_once('wp-load.php');

if (!current_user_can('manage_options')) {
    die('You must be an administrator to run this script.');
}

echo '<h1>HR Management Test Data Generator</h1>';
echo '<p>Generating test data...</p>';

// Sample employee names
$employees = [
    ['name' => 'John Doe', 'email' => 'john@example.com', 'position' => 'Software Engineer', 'department' => 'Engineering', 'phone' => '+1234567890'],
    ['name' => 'Jane Smith', 'email' => 'jane@example.com', 'position' => 'Product Manager', 'department' => 'Product', 'phone' => '+1234567891'],
    ['name' => 'Mike Johnson', 'email' => 'mike@example.com', 'position' => 'Designer', 'department' => 'Design', 'phone' => '+1234567892'],
    ['name' => 'Sarah Williams', 'email' => 'sarah@example.com', 'position' => 'HR Manager', 'department' => 'Human Resources', 'phone' => '+1234567893'],
    ['name' => 'David Brown', 'email' => 'david@example.com', 'position' => 'Sales Executive', 'department' => 'Sales', 'phone' => '+1234567894'],
];

$employee_ids = [];

// Create Employees
echo '<h2>Creating Employees...</h2>';
foreach ($employees as $emp) {
    $employee_id = wp_insert_post([
        'post_title' => $emp['name'],
        'post_type' => 'hrm_employee',
        'post_status' => 'publish',
    ]);
    
    if ($employee_id) {
        update_post_meta($employee_id, 'hrm_employee_email', $emp['email']);
        update_post_meta($employee_id, 'hrm_employee_position', $emp['position']);
        update_post_meta($employee_id, 'hrm_employee_department', $emp['department']);
        update_post_meta($employee_id, 'hrm_employee_phone', $emp['phone']);
        update_post_meta($employee_id, 'hrm_employee_salary', rand(50000, 120000));
        update_post_meta($employee_id, 'hrm_username', strtolower(str_replace(' ', '.', $emp['name'])));
        update_post_meta($employee_id, 'hrm_password', wp_hash_password('password123'));
        
        $employee_ids[] = $employee_id;
        echo "<p>✓ Created employee: {$emp['name']}</p>";
    }
}

// Create Attendance Records
echo '<h2>Creating Attendance Records...</h2>';
for ($i = 0; $i < 15; $i++) {
    $employee_id = $employee_ids[array_rand($employee_ids)];
    $date = date('Y-m-d', strtotime("-$i days"));
    
    $attendance_id = wp_insert_post([
        'post_title' => 'Attendance - ' . $date,
        'post_type' => 'hrm_attendance',
        'post_status' => 'publish',
    ]);
    
    if ($attendance_id) {
        update_post_meta($attendance_id, 'hrm_attendance_employee_id', $employee_id);
        update_post_meta($attendance_id, 'hrm_attendance_date', $date);
        update_post_meta($attendance_id, 'hrm_attendance_check_in', $date . ' 09:00:00');
        update_post_meta($attendance_id, 'hrm_attendance_check_out', $date . ' 17:30:00');
        update_post_meta($attendance_id, 'hrm_attendance_status', 'present');
        
        echo "<p>✓ Created attendance record for $date</p>";
    }
}

// Create Leave Requests
echo '<h2>Creating Leave Requests...</h2>';
$leave_types = ['sick', 'vacation', 'personal'];
$statuses = ['pending', 'approved', 'rejected'];

for ($i = 0; $i < 10; $i++) {
    $employee_id = $employee_ids[array_rand($employee_ids)];
    $start_date = date('Y-m-d', strtotime("+$i days"));
    $end_date = date('Y-m-d', strtotime("+" . ($i + rand(1, 5)) . " days"));
    
    $leave_id = wp_insert_post([
        'post_title' => 'Leave Request - ' . $start_date,
        'post_type' => 'hrm_leave_request',
        'post_status' => 'publish',
    ]);
    
    if ($leave_id) {
        update_post_meta($leave_id, 'hrm_leave_employee_id', $employee_id);
        update_post_meta($leave_id, 'hrm_leave_type', $leave_types[array_rand($leave_types)]);
        update_post_meta($leave_id, 'hrm_leave_start', $start_date);
        update_post_meta($leave_id, 'hrm_leave_end', $end_date);
        update_post_meta($leave_id, 'hrm_leave_reason', 'Test leave request');
        update_post_meta($leave_id, 'hrm_leave_status', $statuses[array_rand($statuses)]);
        
        echo "<p>✓ Created leave request from $start_date to $end_date</p>";
    }
}

// Create Payroll Records
echo '<h2>Creating Payroll Records...</h2>';
$months = ['2024-01', '2024-02', '2024-03', '2024-04', '2024-05'];

foreach ($employee_ids as $employee_id) {
    $month = $months[array_rand($months)];
    
    $payroll_id = wp_insert_post([
        'post_title' => 'Payroll - ' . $month,
        'post_type' => 'hrm_payroll',
        'post_status' => 'publish',
    ]);
    
    if ($payroll_id) {
        $basic = rand(50000, 120000);
        $allowances = rand(5000, 15000);
        $deductions = rand(2000, 8000);
        
        update_post_meta($payroll_id, 'hrm_payroll_employee_id', $employee_id);
        update_post_meta($payroll_id, 'hrm_payroll_period', $month);
        update_post_meta($payroll_id, 'hrm_payroll_basic', $basic);
        update_post_meta($payroll_id, 'hrm_payroll_allowances', $allowances);
        update_post_meta($payroll_id, 'hrm_payroll_deductions', $deductions);
        
        echo "<p>✓ Created payroll record for $month</p>";
    }
}

echo '<h2 style="color: green;">✓ Test Data Generated Successfully!</h2>';
echo '<p><a href="' . home_url() . '">Go to Homepage</a> | <a href="' . admin_url() . '">Go to Admin Dashboard</a></p>';
echo '<p><strong>Note:</strong> You can now test the company dashboard with this sample data.</p>';
